//############################################################################//
//             Copyright (c) 2006, by Deluxe-Menu.com
//             Deluxe Tuner script
//             http://deluxe-menu.com
//             Programming by Shakhmatov Nik
//             E-mail: cs@deluxe-menu.com
//############################################################################//

var dmDeluxeTuner = 0;            // script is used by Deluxe Tuner, not by web browser (html version)

var dm_tunerItems = [];
var dm_keys       = [];
var dm_funcName   = '';
var dm_funcParams = [];

var dm_tunerStyles0 = [];
var dm_tunerStyles1 = [];
var dm_tunerStyleNames0 = [];
var dm_tunerStyleNames1 = [];


var waitFor=null;


//############################################################################//
//  Functions for interaction
//############################################################################//

function dm_getValueHTML(paramType, editID, val)
{
  switch (paramType)
  {
      case 'font':
                    alert('Please, enter font style into the field.\nExamples:\n\n1. normal 9pt Arial\n2. bold 12px Tahoma, Verdana\n3. 600 75% Tahoma, Arial, Helvetica')
                    return dm_setValue(val);
      break;
      case 'image':
                    alert('Please, enter correct image filename into the field.\nExamples:\n\n1. images/pic.gif\n2. ../../pic.gif\n3. http://mywebsite.com/images/pic.gif')
                    return dm_setValue(val);
      break;
      case 'url':
                    alert('Please, enter correct URL into the field.\nExamples:\n\n1. mypage.html\n2. ../../mypage.html\n3. http://mywebsite.com/mypage.html\n\nYou can also use Javascript code instead:\n\njavascript:alert("Hello!")')
                    return dm_setValue(val);
      case 'js':
                    alert('Please, enter correct .js filename into the field.\nExamples:\n\n1. menu/submenu1.js\n2. http://mywebsite.com/menu/submenu2.js')
                    return dm_setValue(val);
      case 'color':
                    alert('Please, enter color value into the field.\nExamples:\n\n1. #FF0000\n2. red\n3. transparent')
                    return dm_setValue(val);
      break;
  }
}


function dm_getValue(paramType, editID)    // used by script
// Sends parameter change command to Tuner
{
  if (waitFor!=null) return;
  var e = document.getElementById(editID);                                  // capture the object
  waitFor = e;

  if (!dmDeluxeTuner) return dm_getValueHTML(paramType, editID, e.value);   // use standard HTML dialog (for HTML Tuner)
  else
      status = '@'+paramType+':'+e.value;                                   // use Tuner GUI
}


function dm_setValue(val)                                                   // used by Win/HTML Tuner Tuner
// Returns changed parameter value from Tuner
{
  if (waitFor!=null) waitFor.value = val;
  waitFor=null;                                                             // uncapture the object
}


function dm_getMenuFontStyle()
{
  var p1 = dm_getParamValue('fontStyle', 'font', 'normal 9pt Trebuchet MS, Tahoma', '', '');
  var p2 = dm_getParamValue('fontColor', 'color-array', '#000000',  '', '', ['',''], '|').split('|')[0];
  var p3 = dm_getParamValue('fontDecoration', 'set-array', 'none',  '', '', ['',''], '|').split('|')[0];
  return 'font:'+p1+';color:'+p2+';text-decoration:'+p3;
}

//############################################################################//
//  Functions for data saving
//############################################################################//

var paramValueExists = false;


function dm_getFileName(fpath)
{
    var fname='';
    for (var i=fpath.length-1; i>=0 && fpath.charAt(i)!='\/'; i--) fname = fpath.charAt(i) + fname;
    return fname;
}


var isSaving = 0;

function dm_getParamValue(pName, pType, pDefValue, globalFilesPath, commasChar, arrBrackets, arrComma)
// Returns param value
{
  var obj = document.getElementById(pName+'_id');
  if (!obj) return commasChar+commasChar;
  
  switch (pType)
  {
    case 'integer-percent':
        paramValueExists = obj.value ? true : false;

        // Check for units for the value and set 'px' units by default if units were not specified
        if (isSaving && obj.value)
        {
            var n  = parseInt(obj.value);
            var ns = ''+n+'';
            var ss = ''+obj.value+'';
            if (ns.length==ss.length) obj.value += 'px';
        }
        
        return obj.value ? commasChar+obj.value+commasChar : commasChar+commasChar;
    break;


    case 'integer':
    case 'integer-nn':
    case 'boolean':
    case 'effect':
        paramValueExists = obj.value ? true : false;
        return obj.value ? obj.value : commasChar+commasChar;
    break;


    case 'set':
    case 'set-add':
        var val = dm_getParam_setadd(pName);
        paramValueExists = val!='' ? true : false;
        return commasChar+val+commasChar;
    break;
    
    
    case 'image':
        var fname = '';
        paramValueExists = obj.value ? true : false;
        if (globalFilesPath && obj.value) fname = globalFilesPath + dm_getFileName(obj.value);
        else
            fname = obj.value;
        return commasChar+fname+commasChar;
    break;

    
    case 'color-array':
    case 'image-array':
    case 'set-array':
    case 'string-array':
    case 'font-array':
        var val=arrBrackets[0];
        var tmpVal='';
        var itemType = pType.replace(/-array/i, '');
        var valueExists = false;
        
        for (var i=0; i<pDefValue.length; i++)
        {
            tmpVal = dm_getParamValue(pName+'_item'+i, itemType, pDefValue[i], globalFilesPath, commasChar, arrBrackets, arrComma);
            if (tmpVal!=(''+commasChar+commasChar)) valueExists = true;
            val += tmpVal + ((i<pDefValue.length-1) ? arrComma : '');
        }

        val += arrBrackets[1];
        paramValueExists = valueExists;
        return val;
    break;


    default:
        paramValueExists = obj.value!='' ? true : false;
        return commasChar+obj.value+commasChar;
  }
}


function dm_getFileNames()
// Returns all file paths in params (makes absolute paths)
{
  var fnames='', pName, pType, pValue;

  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pName = dm_getParam(i, 0);
      pType = dm_getParam(i, 1);
      if (pType=='image' || pType=='image-array')
      {
          fname = dm_getParamValue(pName, pType, dm_getParam(i, 2), '', '', ['',''], String.fromCharCode(13));
          if (paramValueExists) fnames += (fnames ? String.fromCharCode(13) : '') + fname;
      }
  }
  return fnames;
}


function dm_getLineEnd()
// Returns line-end code
{
  if (dmDeluxeTuner)
      return String.fromCharCode(13)+String.fromCharCode(10);
  else
      return '\n';
}


function dm_getParamsList(globalFilesPath)            // used by Tuner
// Returns parameters list for data file
{
  var paramList = '';
  var pName, pType, pValue;
  
  isSaving = 1;
  
  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pType = dm_getParam(i, 1);
      if (pType && pType!='separator')
      {
          pName = dm_getParam(i, 0);
          if (pType!='section')
          {
              pValue = dm_getParamValue(pName, pType, dm_getParam(i, 2), globalFilesPath, '"', ['[',']'], ',');
              paramList += 'var '+pName+'='+pValue+';' + dm_getLineEnd();
          }
          else
              paramList += dm_getLineEnd() + '//--- '+pName + dm_getLineEnd();
      }
  }

  isSaving = 0;

  return paramList;
}


function dm_getKeysList()                            // used by Tuner
// Returns key list for data file
{
  var keysList = '';
  for (var i=0; i<dm_keys.length; i++)
      keysList += 'var key'+((i==0)?'':i) + '="'+dm_keys[i]+'";' + dm_getLineEnd();

  return keysList;
}


function dm_getStylesArray(curProjectPath)           // used by Tuner
// Returns styles arrays for data file
{
  var pName, pType, pValue;
  var stylesArr = '[';
  var n=0;

  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pType = dm_getParam(i, 1);
      if (pType && pType!='section' && pType!='separator')
      {
          pName  = dm_getParam(i, 0);
          pValue = dm_getParamValue(pName, pType, dm_getParam(i, 2), curProjectPath, '', ['',''], ',');
          if (paramValueExists)
          {
          //    pValue = pValue.replace(/\[/g, '');        // delete array brackets
          //    pValue = pValue.replace(/\]/g, '');        // --=--
              stylesArr += (n?',':'') + '"'+pName+'='+pValue+'"';
              n++;
          }
      }
  }

  return stylesArr+']';
}


//############################################################################//
//  Additional functions for parameters
//############################################################################//

function dm_setParam(pInd, pName, pType, pValue)
// Sets parameter value using p. name, p. type and p. value
{
  switch (pType)
  {
    case 'set-add':
    case 'set':
        dm_setParam_setadd(pName, pValue);
    break;


    case 'color-array':
    case 'image-array':
    case 'set-array':
    case 'string-array':
    case 'font-array':
        var itemType = pType.replace(/-array/i, '');
        for (var i=0; i<pValue.length; i++)
        {
            if (typeof(pValue[i])=='undefined') pValue[i] = '';
            dm_setParam(pInd, pName+'_item'+i, itemType, pValue[i]);
        }
    break;

    case 'effect':
        obj = document.getElementById(pName+'_id');
        objSel = document.getElementById(obj.id+'_sel');
        if (obj) obj.value = pValue;
        objSel.selectedIndex = pValue;
    break;

    default:
        obj = document.getElementById(pName+'_id');
        if (obj) obj.value = pValue;
  }
}


function dm_getDefaultValue(pType, pDefValue)
// Returns corrected value from default parameter value
{
  switch (pType)
  {
    case 'set-add':
    case 'set':
        return pDefValue.split(',')[0];
    break;


    case 'color-array':
    case 'image-array':
    case 'set-array':
    case 'string-array':
    case 'font-array':
        var itemType = pType.replace(/-array/i, '');
        var result=[];
        for (var i=0; i<pDefValue.length; i++)
            result[i] = dm_getDefaultValue(itemType, pDefValue[i]);

        return result;
    break;
    

    default: return pDefValue;
  }
}



function dm_resetParams()                  // used by Tuner
// Resets all parameters values on a page
{
  var pName, pType, pDefValue, pValue;

  canModify = false;
  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pType = dm_getParam(i,1);
      if (pType && pType!='separator' && pType!='section')
      {
          pName     = dm_getParam(i,0);
          pDefValue = dm_getParam(i,2);
          dm_setParam(i, pName, pType, dm_getDefaultValue(pType, pDefValue));
      }
  }
  dm_tunerItems = [];         // reset menu items
  canModify = true;
}


//############################################################################//
//  Functions for data loading
//############################################################################//

function dm_preDefineVars()
// Defines parameters script variables according to default parameters values
{
  var pName, pType, pDefValue, pValue;
  var preScript='';

  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pType = dm_getParam(i,1);
      if (pType && pType!='separator' && pType!='section')
      {
          pName     = dm_getParam(i,0);
          pDefValue = dm_getParam(i,2);
          pValue    = dm_getParamValue(pName, pType, pDefValue, '', '"', ['[',']'], ',');
          preScript += pName + '=' + pValue +';'+String.fromCharCode(13);
      }
  }

  eval(preScript);
}


function dm_loadParams(script, itemsName, stylesName0, stylesName1, isTemplate)  // used by Tuner
// Loads parameters variables from specified script code
{
  var pName, pType, pValue;
  dm_preDefineVars();
  eval(script);

  canModify = false;
  for (var i=0; i<dm_tunerParams.length; i++)
  {
      pType = dm_getParam(i,1);
      if (pType && pType!='separator' && pType!='section')
      {
          pName = dm_getParam(i,0);
          eval('pValue = ' + pName + ';');        // set pValue value
          dm_setParam(i, pName, pType, pValue);
      }
  }
  canModify = true;

  if (!isTemplate)
      eval('if (typeof('+itemsName+')!="undefined") dm_tunerItems = ' + itemsName + ';');                       // load menu items


  //--- Load individual styles -------------------------------------------------
  if (stylesName0)                                // load item styles
  {
      eval('if (typeof('+stylesName0+')!="undefined") dm_tunerStyles0='+stylesName0+'; else dm_tunerStyles0=[];');
      eval('if (typeof('+stylesName0+'Names)!="undefined") dm_tunerStyleNames0='+stylesName0+'Names; else dm_tunerStyleNames0=[];');
  }
  else
  {
      dm_tunerStyles0=[];
      dm_tunerStyleNames0=[];
  }

  if (stylesName1)                                // load menu styles
  {
      eval('if (typeof('+stylesName1+')!="undefined") dm_tunerStyles1='+stylesName1+'; else dm_tunerStyles1=[];');
      eval('if (typeof('+stylesName1+'Names)!="undefined") dm_tunerStyleNames1='+stylesName1+'Names; else dm_tunerStyleNames1=[];');
  }
  else
  {
      dm_tunerStyles1=[];
      dm_tunerStyleNames1=[];
  }


  //--- Load keys --------------------------------------------------------------
  if (!isTemplate)
  {
      dm_keys = [];
      if (typeof(key)!='undefined')
      {
          dm_keys[0] = key;
          kInd=1;
          while (eval('typeof(key'+kInd+')!="undefined"'))
          {
              eval('dm_keys['+kInd+']=key'+kInd+';');
              kInd++;
          }
      }
  }
}

function dm_init()
{
  dm_funcName = 'dm_init';
  dm_funcParams = dm_init.arguments;
}

function dm_initFrame()
{
  dm_funcName = 'dm_initFrame';
  dm_funcParams = dm_initFrame.arguments;
}

function dm_getInitFuncName(isPreview)
{
  if (!isPreview && dm_funcName=='dm_initFrame')  return dm_funcName+'("'+dm_funcParams[0]+'", '+dm_funcParams[1]+', '+dm_funcParams[2] + ', '+dm_funcParams[3]+');';
                                             else return 'dm_init();';
}


//############################################################################//
//  Functions for styles loading (used by Tuner for internal style names)
//############################################################################//

function dm_getStyleParamsCount(stylesType) {
  return (stylesType==0)?dm_tunerStyles0.length:dm_tunerStyles1.length;
}


function dm_getStyleName(stylesType, styleInd)
// Returns style name for specified style type
{
  var Names = (stylesType==0)?dm_tunerStyleNames0:dm_tunerStyleNames1;

  if (typeof(Names[styleInd])!='undefined')
      return Names[styleInd];
  else
      return '';
}


function dm_getStyleParamsList(stylesType, styleInd)
// Returns specified style parameter
{
  var style = (stylesType==0) ? dm_tunerStyles0[styleInd] : dm_tunerStyles1[styleInd];

  if (typeof(style)=='undefined' || !style) return '';
  
  var params='';
  for (var i=0; i<style.length; i++)
      if (typeof(style[i])!='undefined' && style[i]) params += '"' + style[i] + '"' + ((i<style.length-1)?',':'');
          
  return params;
}


//############################################################################//
//  Functions for menu items
//############################################################################//

function dm_getItemsCount() {
  return dm_tunerItems.length;
}


function dm_getItemParam(itemInd, paramInd)
// Returns item parameter
{
  if (typeof(dm_tunerItems[itemInd])=='undefined') return '@undefined';
  else
      if (typeof(dm_tunerItems[itemInd][paramInd])!='undefined' && dm_tunerItems[itemInd][paramInd]!=null)
          return dm_tunerItems[itemInd][paramInd];
}


